package w83b.w83bUtilidades;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;

import java.util.Date;

import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 * @author 
 *
 */
public class W83bUtilidadesPdf{
	
	private W83bUtilidadesPdf(){}
	
	public static class HeaderFooter extends PdfPageEventHelper {    
        //Declaramos el pie de pgina como un Phrase
        Phrase pie = new Phrase();//NOPMD
        String idioma;//NOPMD
        String direccion;//NOPMD
        
        public HeaderFooter(String id, String dir){
        	idioma=id;
        	direccion=dir;
        }
     
        //Evento que se ejecuta al terminar una pgina
        public void onEndPage(PdfWriter writer, Document document) {
          try {
        	Rectangle rect = writer.getBoxSize("art");
        	Font helvetica = new Font(BaseFont.createFont(BaseFont.HELVETICA, "Cp1252", false), W83bClsConstantes.SIETE);
			pie = new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{String.valueOf(writer.getCurrentPageNumber())}),helvetica);
			ColumnText.showTextAligned(writer.getDirectContent(),
	                  Element.ALIGN_CENTER, new Phrase(direccion,helvetica),
	                  (rect.getLeft() + rect.getRight()) / 2, rect.getBottom() - W83bClsConstantes.VEINTE, 0);  
	        ColumnText.showTextAligned(writer.getDirectContent(),
	                  Element.ALIGN_RIGHT, pie,
	                  rect.getRight(), rect.getBottom() - W83bClsConstantes.VEINTE, 0);   
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

          
        }   
      }
	
    public static void ponerCabecera (ByteArrayOutputStream baos, String provincia, String idioma, String modo){   
        try{
        	PdfReader reader = new PdfReader(new ByteArrayInputStream(((ByteArrayOutputStream) baos).toByteArray()));
        	int n = reader.getNumberOfPages();
        	PdfStamper stamp = new PdfStamper(reader,  baos);
        	int i = 1;
        	PdfContentByte under;
        	PdfContentByte over;
        	Image logo;
        	if ("horizontal".equals(modo)){
        		logo= Image.getInstance(Q70ListenerUtils.getApplicationProperty("WEBROOT_W83BESTATICO")+"logoGV.jpg");
        		logo.scaleToFit(300, 300);
        	}
        	else{
        		logo= Image.getInstance(Q70ListenerUtils.getApplicationProperty("WEBROOT_W83BESTATICO")+"logoGVvertical.jpg");
        		logo.scaleToFit(275, 275);
        	}
        	
        	logo.setAlignment(Element.ALIGN_MIDDLE);
        	logo.setSpacingAfter((float)W83bClsConstantes.VEINTE);
        	if ("horizontal".equals(modo)){
        		logo.setAbsolutePosition((float)272, (float)540);//para encajar la imagen en la cabecera de pagina
        	}
        	else{
        		logo.setAbsolutePosition((float)162, (float)800);//para encajar la imagen en la cabecera de pagina
        	}
        	Date date = new Date();
        	SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
        	String fecha = sdf.format(date);

        	SimpleDateFormat sdfEuskera=new SimpleDateFormat("yyyy/MM/dd");
        	String fechaEuskera = sdfEuskera.format(date);
        	
        	StringBuffer tituloImagenEs = new StringBuffer();
        	StringBuffer tituloImagenEu = new StringBuffer();
        	
        	if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
            }else if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
            }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
            }
            else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
            	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
            	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
            }
        	
        	while (i < n + 1)  {              	
        		// Watermark under the existing page
            	under = stamp.getUnderContent(i);
            	over = stamp.getOverContent(i);
            	
            	StringBuffer txt= new StringBuffer();//NOPMD
            	if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
            		txt.append(fecha);
            	}
            	else{
            		txt.append(fechaEuskera);
            	}
	            // Crear fuente debe ser una base
	            BaseFont bf = BaseFont.createFont(BaseFont.HELVETICA, "Cp1252", false);
	            //   comienzo a escribir texto
	            under.beginText();
	            //  la fuente a utilizar
	            under.setFontAndSize(bf, W83bClsConstantes.SIETE);
	            // la posiciisBon en la que va a ser colocado el texto
	            if ("horizontal".equals(modo)){
	            	under.setTextMatrix((float)725,(float)565);
	            }
	            else{
	            	under.setTextMatrix((float)535,(float)825);
	            }
	            // Escribo el texto
	            under.showText(txt.toString());
	            // Indico que termine de agregar texto
	            under.endText();
            	
            	under.beginText();
            	under.setFontAndSize(bf, W83bClsConstantes.SIETE);
            	if ("horizontal".equals(modo)){
            		under.setTextMatrix((float)50,(float)565);
            	}
            	else{
            		under.setTextMatrix((float)20,(float)825);
            	}
            	under.showText(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.eleccionesSindicales",idioma));
            	under.endText();
            	
              	// coloca la imagen sobre el margen
            	over.addImage(logo);
            	over.beginText();
                BaseFont bf_times = BaseFont.createFont(BaseFont.HELVETICA_BOLD, "Cp1252", false);
                BaseFont bf_timescur = BaseFont.createFont(BaseFont.HELVETICA_OBLIQUE, "Cp1252", false);
                over.setFontAndSize(bf_times, W83bClsConstantes.SIETE); 
                if ("horizontal".equals(modo)){
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme1Abr_eu",idioma), 282, 538, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme2Abr_eu",idioma), 282, 530, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme1Abr_es",idioma), 450, 538, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme2Abr_es",idioma), 450, 530, 0);
                    over.setFontAndSize(bf_timescur, W83bClsConstantes.SIETE);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEu.toString(), 282, 522, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEs.toString(), 450, 522, 0);   
                }
                else{
                	over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme1Abr_eu",idioma), 171, 798, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme2Abr_eu",idioma), 171, 790, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme1Abr_es",idioma), 325, 798, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme2Abr_es",idioma), 325, 790, 0);
                    over.setFontAndSize(bf_timescur, W83bClsConstantes.SIETE);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEu.toString(), 171, 782, 0);
                    over.showTextAligned(PdfContentByte.ALIGN_LEFT, tituloImagenEs.toString(), 325, 782, 0);   
                }
                
                over.endText();
                i++;
        	}
        	stamp.close();
        	
        }catch(Exception e){
        	W83bClsTrazas.trazaError(null,"error ponerCabecera->"+e.getMessage(),e.getCause());
        }
        
    }


}